/**
 * Shared app bootstrap. No business logic, no financial calculations.
 * Session handling assumed server-side; this only registers PWA and offline UI.
 */
(function () {
  'use strict';

  if ('serviceWorker' in navigator) {
    window.addEventListener('load', function () {
      navigator.serviceWorker.register('/service-worker.js').catch(function () {});
    });
  }

  window.showOfflineBanner = function () {
    var el = document.getElementById('offline-banner');
    if (el) {
      el.classList.add('visible');
      el.style.display = 'block';
    }
  };

  window.hideOfflineBanner = function () {
    var el = document.getElementById('offline-banner');
    if (el) {
      el.classList.remove('visible');
      el.style.display = '';
    }
  };

  function updateOnlineStatus() {
    if (!navigator.onLine) window.showOfflineBanner();
    else window.hideOfflineBanner();
  }

  window.addEventListener('online', updateOnlineStatus);
  window.addEventListener('offline', updateOnlineStatus);
  updateOnlineStatus();
})();
