# Advanced Fraud Prevention System

## Design principles

- All detection and enforcement is server-side.
- No reliance on frontend for rate limits, eligibility, or balance changes.
- Logging and risk scoring support manual review and automatic suspension.

## Components

### 1. IP rate limiting
- Limit requests per IP per endpoint (e.g. login, signup, task complete, withdrawal).
- Use tiered limits: stricter for financial and task-completion endpoints.
- Block or delay when threshold exceeded; log to fraud_logs.
- Use Redis or similar for distributed counters and cooldowns.

### 2. Device fingerprinting
- Collect fingerprint (e.g. hash of user-agent, screen, timezone, language) on login/signup and at critical actions.
- Store fingerprint with user or session; detect multiple accounts from same device.
- Flag or block when one device is associated with many accounts or rapid task completion across accounts.

### 3. Geo mismatch detection
- Store country/region at signup and at login (from IP or header).
- Flag logins or withdrawals from country different from signup or usual pattern.
- Optional: block high-risk regions or require extra verification.

### 4. VPN / proxy detection
- Use IP reputation or third-party API to flag VPN/proxy IPs.
- Don’t necessarily block; use as input to risk score and manual review queue.

### 5. Behavioral analysis
- Track session duration, click patterns, time between tasks.
- Flag bot-like behavior: too regular intervals, no scroll/watch time, impossible completion speed.
- Compare watch time to task duration_seconds; flag if completion in far less time than required.

### 6. Task completion velocity
- Limit completions per user per hour/day (server-side).
- Flag users who complete tasks at unrealistically high rate.
- Per-task: enforce minimum time before “complete” is accepted (e.g. ≥ duration_seconds).

### 7. Earnings spike detection
- Monitor daily/weekly earnings per user.
- Flag when earnings exceed N× the user’s or global average.
- Feed into risk score and manual review; optionally delay payout.

### 8. Withdrawal anomaly detection
- Flag first-time withdrawal soon after signup, or large increase vs history.
- Flag many small withdrawals in short period (structuring).
- Cross-check withdrawal amount vs recent earnings and balance history.

### 9. Risk scoring engine
- Aggregate signals: IP, device, geo, velocity, earnings spike, withdrawal pattern, KYC status.
- Compute numeric risk score per user or per action.
- Thresholds: auto-flag (review queue), auto-delay payout, or auto-suspend account.
- Store risk_score on users and in fraud_logs per event.

### 10. Automatic account suspension
- When risk score exceeds threshold or critical rule fires (e.g. same task completed twice due to bug), suspend account (set suspended_at).
- Require manual admin review to unsuspend.
- All balance and withdrawal actions check suspended_at.

### 11. Manual review queue
- Admin panel: list of flagged users/withdrawals/fraud_logs.
- Actions: approve, reject, suspend, unsuspend, add note.
- All actions logged in audit_logs.

### 12. Idempotent task completion
- Unique constraint (user_id, task_id) in user_task_completion.
- Use “INSERT … ON CONFLICT DO NOTHING” or check-then-insert in transaction so double-submit does not double-credit.
- Return same success response on duplicate attempt.

## Data flow

1. Request hits API → rate limit check (IP, user).
2. Load user, check suspended_at and email_verified_at.
3. For task complete: validate task_id, check not already completed, validate watch time/duration, update velocity counters.
4. Compute risk score for action; update user risk_score; write fraud_log if needed.
5. If risk high: redirect to review queue or suspend; else proceed.
6. Perform financial operation in DB transaction; write audit_log.
7. Return read-only result to client.

## Logging

- fraud_logs: event_type, user_id, payload_json, risk_score, created_at.
- audit_logs: actor_type, actor_id, action, resource, resource_id, payload_json, ip_address, user_agent.
- No PII in logs beyond what’s necessary; consider hashing or truncation for sensitive fields.
