# Video Earn Platform

Production-grade Web + PWA earning platform where users earn money by watching videos. Static HTML, inline-capable CSS, vanilla JavaScript only. Backend-ready with enterprise financial security standards.

## Stack

- **Frontend**: Static HTML, CSS (theme.css + page-specific styles), Vanilla JS only. No React, Vue, Next.js, or external animation libraries.
- **PWA**: manifest.json, service-worker.js. Offline: splash/fallback only; no task completion when offline.
- **Backend**: All business logic, CPC, profit %, and balance updates are server-side. See `docs/BACKEND_ARCHITECTURE.md`.

## Business model

- **Formula**: User Profit = Admin-Controlled Profit % × User's CPC (Pakistan).
- Default profit: 30%. Admin can set 1–100%. CPC never exposed in frontend; all calculations server-side.
- Earnings and balance are read-only in the UI.

## Project structure

```
├── index.html, signup.html, login.html, verify.html   # Public
├── dashboard.html, tasks.html, wallet.html, withdraw.html, profile.html, earnings-history.html  # User
├── admin/admin-dashboard.html, admin-tasks.html, admin-withdrawals.html, admin-settings.html, admin-analytics.html
├── legal/privacy-policy.html, terms-of-service.html, risk-disclosure.html, aml-policy.html, kyc-policy.html
├── css/theme.css
├── js/app.js
├── manifest.json, service-worker.js
├── sql/schema.sql
├── docs/
│   ├── BACKEND_ARCHITECTURE.md
│   ├── FRAUD_PREVENTION.md
│   ├── BINANCE_OKX_INTEGRATION.md
│   ├── LEGAL_COMPLIANCE.md
│   └── PRODUCTION_DEPLOYMENT.md
└── icons/   # Add icon-72.png, icon-192.png, icon-512.png for PWA
```

## Running locally

Serve the project over HTTPS (or localhost) so the service worker and manifest work. For example:

```bash
npx serve -l 3000
# Or use your own static server; ensure paths are correct (e.g. /css/theme.css).
```

API endpoints are placeholders; implement them in your backend and point the frontend to your API origin.

## Security

- No CPC, profit %, or API keys in frontend. No financial calculations in JS.
- Session handling assumed server-side (HTTP-only secure cookies). No tokens stored insecurely.
- Strict role separation (user vs admin). See docs for fraud prevention, Binance/OKX integration, and deployment (NGINX, HSTS, CSP, rate limiting).

## Legal

Privacy Policy, Terms of Service, Risk Disclosure, AML Policy, and KYC Policy are under `legal/`. They explain earnings structure, fraud monitoring, and wallet encryption.

## Database

See `sql/schema.sql` for tables: users, tasks, user_task_completion, withdrawals, admin_settings, fraud_logs, analytics_aggregates, kyc_records, audit_logs, user_wallets.

## Icons

Add PWA icons in `icons/`: icon-72.png, icon-192.png, icon-512.png (or update manifest.json to your paths).
